//Digital Lighting Controller
//drives Slave units
//Also drives addressable LEDs using Neopixel library

//Neopixel library
#include <Adafruit_NeoPixel.h>
#define RGB_PIN 6
#define NUMPIXELS 64
Adafruit_NeoPixel pixels(NUMPIXELS, RGB_PIN, NEO_GRB + NEO_KHZ800);

//for DLC data
//below works for Uno/Mega
#define DATA_PIN 1
#define DATA_SERIAL Serial

/*
//use below for Leonardo
#define DATA_PIN 1
#define DATA_SERIAL Serial1

//Using other TX ports on Mega
//TX3
#define DATA_PIN 14
#define DATA_SERIAL Serial3

//TX2
#define DATA_PIN 16
#define DATA_SERIAL Serial2

//TX1
#define DATA_PIN 18
#define DATA_SERIAL Serial1

*/

#define LAMPCOUNT 64
byte b[LAMPCOUNT]={
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };  

byte pattern[16]={0,32,64,96,128,160,192,224,255,224,192,160,128,96,64,32};

void setup() {
  int i;
  //set idle state
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
  sendFrame(b,LAMPCOUNT);                 //blank initial array

  pixels.begin(); // INITIALIZE NeoPixel strip object (REQUIRED)  
  for(int i=0; i<NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(0,0,0));
  }
  pixels.show();   // Send the updated pixel colors to the hardware.
}

void loop() {
  //to send lamp data
  //set array b to the desired values
  //then 
  //sendFrame(b,LAMPCOUNT);  //send DLC data
 
  //to set Addressable LED data
  //set colours
  //pixels.setPixelColor(LED_NUMBER, pixels.Color(RED,GREEN,BLUE));
  //then send data
  //pixels.show();   // Send the updated pixel colors to the hardware.

  //the following give brief snippets of some animations

  allOn();
  delay(1000);
  allOff();
  delay(1000);  
  chase(255,0,255,5,500,5000);    //chase rgb(255,0,255) in steps of 5 for 5000ms
  fade(0,255,5000);               //fade up over 5000ms
  fade(255,0,5000);               //fade down over 5000ms
  mix(10000);                     //mixed pattern for 10000ms
  twinkle(500,10000);             //random patterns at 500ms intervals for 10000ms
}

void twinkle(long s, long t){     //random twinkles
  unsigned long t0,s0;
  int i;
  t0=millis();
  while(millis()-t0<t){
    s0=millis();
    //all off
    for(i=0;i<LAMPCOUNT;i++){
      b[i]=0;
    }
    for(int i=0; i<NUMPIXELS; i++) {
      pixels.setPixelColor(i, pixels.Color(0,0,0));
    }
    for(i=0;i<(LAMPCOUNT/8);i++){ //only some of the LAMPS
      b[random(LAMPCOUNT)]=random(256);
    }
    for(int i=0; i<(NUMPIXELS/4); i++) {  //only some of the LEDs
      pixels.setPixelColor(random(NUMPIXELS), pixels.Color(random(256),random(256),random(256)));
    }    
    sendFrame(b,LAMPCOUNT);  //send DLC data
    pixels.show();   // Send the updated pixel colors to the hardware.    
    while(millis()-s0<s){}    

  }
}

void mix(long t){
  //fade through lamps, but rainbow on LEDs
  unsigned long t0;
  int i,j,k;
  t0=millis();
  while(millis()-t0<t){
    for(i=0;i<LAMPCOUNT;i++){
      b[i]=pattern[(i+j)%16];
    }
  for(int i=0; i<NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(pattern[(i+j+5)%16],pattern[(i+j+10)%16],pattern[(i+j)%16]));
  }
  sendFrame(b,LAMPCOUNT);  //send DLC data
  pixels.show();   // Send the updated pixel colors to the hardware.    
  j=(j+15)%16;
  delay(100);
  }    
}

void fade(int v0, int v1, long t){   //fade from v0 to v1 over t
  unsigned long t0,f,v;
  t0=millis();
  while(millis()-t0<t){
     f=256*(millis()-t0)/t;   //fraction of interval
     v=(f*v1+(256-f)*v0)/256;
     setAll(v,v,v);
     delay(50);
  }  
  setAll(v1,v1,v1); //ensure we end up at v1
}

void setAll(int red, int green, int blue){
  int i;
  for(i=0;i<LAMPCOUNT;i++){
    b[i]=(red+green+blue)/3;
  }
  for(int i=0; i<NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(red,green,blue));
  }
  sendFrame(b,LAMPCOUNT);  //send DLC data
  pixels.show();   // Send the updated pixel colors to the hardware.    
}

void allOff(){
  int i;
  for(i=0;i<LAMPCOUNT;i++){
    b[i]=0;
  }
  for(int i=0; i<NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(0,0,0));
  }
  sendFrame(b,LAMPCOUNT);  //send DLC data
  pixels.show();   // Send the updated pixel colors to the hardware.  
}

void allOn(){
  int i;
  for(i=0;i<LAMPCOUNT;i++){
    b[i]=255;
  }
  for(int i=0; i<NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(255,255,255));
  }
  sendFrame(b,LAMPCOUNT);  //send DLC data
  pixels.show();   // Send the updated pixel colors to the hardware.  
}

void chase(int red, int green, int blue, int steps, int interval, long t){
  int i,s;
  s=0;
  unsigned long startTime=millis();
  unsigned long stepTime;
  while(millis()-startTime<t){
    stepTime=millis();
    for(i=0;i<LAMPCOUNT;i++){
      if((i%steps)==s){
        b[i]=255;
      }else{
        b[i]=0;
      }      
    }
    for(i=0;i<NUMPIXELS;i++){
      if((i%steps)==s){
        pixels.setPixelColor(i, pixels.Color(red,green,blue));
      }else{
        pixels.setPixelColor(i, pixels.Color(0,0,0));
      }            
    }
    s=(s+1)%steps;
    sendFrame(b,LAMPCOUNT);  //send DLC data
    pixels.show();   // Send the updated pixel colors to the hardware.
    while(millis()-stepTime<interval){}    
  }
}

void sendFrame(char* d, int n){ //array d of size n
  int i;
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
  digitalWrite(DATA_PIN,LOW);     //idle high
  delayMicroseconds(572);         //22 bit times
  digitalWrite(DATA_PIN,HIGH);    //idle high
  DATA_SERIAL.begin(38400);
  DATA_SERIAL.write(0);           //data to follow
  for(i=0;i<n;i++){
    DATA_SERIAL.write(d[i]);
  }
  DATA_SERIAL.end();
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set

  //do this twice to work with LED Slave

  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
  digitalWrite(DATA_PIN,LOW);     //idle high
  delayMicroseconds(572);         //22 bit times
  digitalWrite(DATA_PIN,HIGH);    //idle high
  DATA_SERIAL.begin(38400);
  DATA_SERIAL.write(0);           //data to follow
  for(i=0;i<n;i++){
    DATA_SERIAL.write(d[i]);
  }
  DATA_SERIAL.end();
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set

}

